/**
 * Automatically bound by the persist framework.
 * Dont forget to press F7 to check its validity.
 *
 *
 * This map has a few states,
 *
 * HasAccessOutsideOfKamajsReturn:
 *  Starts in a false state, then when you get Tilde AND talk to the village elder the storm ends.
 *  false: When exiting north of Return, a sandstorm blocks your way, forcing you back to Return.
 *  true: People are glad you are leaving.
 *
 * Kamajs_negociations:
 *  Starts in a false state, then, when you talk to the most northern villager/salesman, it becomes true after a cutscene.
 *  false: Nobody talks to you. They say '...' and some houses cannot be entered (village elder's house).
 *         Crates block the northern exit. A villager blocks the southern exit.
 *  true: People talk to you, the villager up south now gets out of the way and says something about a girl.
 *
 * TildeHasJoined:
 * Starts in a false state, then, when you get inside the mine and find Tilde, she joins.
 * false: 
 * true: People in Kamajs treat you badly and want you out of town. Otoh, the sandstorm is over and now you can leave
 */
({
	/**
	 * Map scripts.
	 * Empty ones can be omitted if desired.
	 */
	enter: function (map, world) {
		// WARP variable used by teleporthica.js to define multiple entrypoints
		WARP = {
			mapname:"The village of Return",
			// Northern entrypoint (pathway between Return and Next)
			north: {
				tx:2,
				ty:2,
			},
			// The center of Return, where you get teletransported to the first time
			center: {
				tx: 19,
				ty: 36
			},
			// Southern entrypoint, to the mines where you find Tilde
			south: {
				tx:7,
				ty:62
			}
		};

		// Put boxes on northern entry so you cant go outside the village
		DoBlockadeBoxes = function(){
			var base = 1; // Hardcoded, not good, should be layer which name is _0

			// x,y is lower left base of the crate
			var putCrate=function(x,y){
				if(y-3>=0){SetTile(x, y-3, base+1, 54); SetTile(x+1, y-3, base+1, 55);}
				if(y-2>=0){SetTile(x, y-2, base, 63); SetTile(x+1, y-2, base, 64);}
				if(y-1>=0){SetTile(x, y-1, base, 72); SetTile(x+1, y-1, base, 73);}
				if(y>=0){SetTile(x, y, base, 81); SetTile(x+1, y, base, 82);}
			};
			var clearCrate=function(x,y){
				if(y-3>=0){SetTile(x, y-3, base+1, 0); SetTile(x+1, y-3, base+1, 0);}
				if(y-2>=0){SetTile(x, y-2, base, 1); SetTile(x+1, y-2, base, 1);}
				if(y-1>=0){SetTile(x, y-1, base, 1); SetTile(x+1, y-1, base, 1);}
				if(y>=0){SetTile(x, y, base, 1); SetTile(x+1, y, base, 2);}
			};

			putCrate(5,2);
			putCrate(7,2);
			putCrate(11,2);
			putCrate(12,2);
			putCrate(9,2);
			putCrate(14,2);
			putCrate(10,4);
			clearCrate(31,19);
			clearCrate(37,19);
			clearCrate(37,16);
			clearCrate(39,20);
			clearCrate(39,17);
			clearCrate(4,26);
		};
	
		if(GetMapFlag('TildeHasJoined') && !GetMapFlag('HasAccessOutsideOfKamajsReturn'))
			SetMapFlag('HasAccessOutsideOfKamajsReturn',1)

		//Blocks get placed before the exits
		if(!GetMapFlag('HasAccessOutsideOfKamajsReturn')){
			DoBlockadeBoxes();
			Game.lithonite.setposTile(8,5, 'Villager_1',true);
			Game.lithonite.reposTile(2,0, 'Villager_3',true);
		}else{
			// He's blocking the southern exit of Return, so delete him (will appear in his home)
			DestroyPerson('Villager_tilde'); 
		}

	},

	// This is the guy blocking the southern exit until you hear about Tilde
	Villager_tilde:{
		create: function(){
			SetPersonDirection(GetCurrentPerson(), "lookeast");
			// Give this poor man some clothes
			Game.mixrss.SetSpritebase( GetPersonSpriteset(GetCurrentPerson()) );
			Game.mixrss.overMix("male/body/02.labcoat_white.rss");
			Game.mixrss.overMix("male/head/06.hair_70ties_black.rss", Game.ColorMatrix["hue_blue55"]);
			Game.mixrss.overMix("male/legs/01.shoes_redsneakers.rss", ColorMatrix["Swap_red_and_blue"]);
			SetPersonSpriteset(GetCurrentPerson(), Game.mixrss.GetSpritebase());
		},
		talk: function(){
			Game.lithonite.facePerson(undefined, GetCurrentPerson(), 'look', 'look', true);
			var say = "...";
			if( GetMapFlag('Kamajs_negociations') )
				say =  "Cant wait to check out the goodies we bought."
				+ " It will be a while before we can get back to the mines just south."
				+ " Speaking about the mines, this girl went there yesterday and she hasnt come back.";
			else if(!GetMapFlag('HasAccessOutsideOfKamajsReturn') && GetMapFlag('Kamajs_negociations'))
				say = "You should go talk to the Village Elder.";

			nQ({ action: 'Talk',
				caption: "Villager",
				settings:{ nameWindowAlignment : ALIGNMENT_TOPRIGHT }, // captionWindowAlignment
				text:  say
			});
			nQ(Game.lithonite.unfacePerson, Game.lithonite, undefined, GetCurrentPerson());
			CutScene_Play('TalkTo Villager_tilde');
		}
	},

//." Even so, I wonder where the girl went, she went to the mines and hasnt come back in a while."

	// This is the guy near the water pump
	Villager_water:{
		create: function(){
			SetPersonDirection(GetCurrentPerson(), "lookeast");
			// Give this poor man some clothes
			Game.mixrss.SetSpritebase( GetPersonSpriteset(GetCurrentPerson()) );
			Game.mixrss.overMix("male/body/02.labcoat_white.rss");
			Game.mixrss.overMix("male/head/06.hair_70ties_black.rss", Game.ColorMatrix["hue_blue55"]);
			Game.mixrss.overMix("male/legs/01.shoes_redsneakers.rss", ColorMatrix["Swap_red_and_blue"]);
			SetPersonSpriteset(GetCurrentPerson(), Game.mixrss.GetSpritebase());
		},
		talk: function(){
			if(!GetMapFlag('Kamajs_negociations')){
				Game.lithonite.facePerson(undefined, GetCurrentPerson(), 'look', 'look', true);
				nQ({ action: 'Talk',
					caption: "Villager",
					settings:{ portraitWindowAlignment : ALIGNMENT_TOPRIGHT },
					text: "..."
				});
				nQ(Game.lithonite.unfacePerson, Game.lithonite, undefined, GetCurrentPerson());
				CutScene_Play('TalkTo Villager_water');
			}else if( GetMapFlag('TildeHasJoined') ) {
				Game.lithonite.facePerson(undefined, GetCurrentPerson(), 'look', 'look', true);
				nQ({ action: 'Talk',
					portrait: "portrait/kamajs_villager1.png",
					settings:{ portraitWindowAlignment : ALIGNMENT_TOPRIGHT },
					text: "Ah it's you! Thanks young lady for that scarf, as you can see it worked pretty well.\n"
					+ "Some in our village arent too fond of you two, it would be best for you to leave."
				});
				nQ(Game.lithonite.unfacePerson, Game.lithonite, undefined, GetCurrentPerson());
				CutScene_Play('TalkTo Villager_water');
			}else{
				Game.lithonite.facePerson(undefined, GetCurrentPerson(), 'look', 'look', true);
				nQ({ action: 'Talk',
					portrait: "portrait/kamajs_villager1.png",
					settings:{ portraitWindowAlignment : ALIGNMENT_TOPRIGHT },
					text: "I think I fixed it. We were losing water. Good thing that weird girl gave me her scarf."
				});
				nQ(Game.lithonite.unfacePerson, Game.lithonite, undefined, GetCurrentPerson());
				CutScene_Play('TalkTo Villager_water');
			}
		}
	},

	Villager_1: {
		create: function(){
			SetPersonDirection(GetCurrentPerson(), "looksouth");

			// Give this poor man some clothes
			Game.mixrss.SetSpritebase( GetPersonSpriteset(GetCurrentPerson()) );
			//Game.mixrss.overMix("male/body/02.labcoat_white.rss");
			Game.mixrss.overMix("male/head/06.hair_70ties_black.rss", Game.ColorMatrix["hue_blue55"]);
			Game.mixrss.overMix("male/legs/01.shoes_redsneakers.rss", ColorMatrix["Swap_red_and_blue"]);
			//Game.mixrss.save("xxxxxxx.rss");
			SetPersonSpriteset(GetCurrentPerson(), Game.mixrss.GetSpritebase());
		},
		talk: function(){
			Game.lithonite.facePerson(undefined, GetCurrentPerson(), 'look', 'look', true);
			if(GetMapFlag('HasAccessOutsideOfKamajsReturn')){
				nQ({ action: 'Talk',
					portrait: "portrait/kamajs_villager1.png",
					settings:{ portraitWindowAlignment : ALIGNMENT_TOPRIGHT },
					text: "Well, we have sold everything, we should be going home soon."
				});
				nQ(Game.lithonite.unfacePerson, Game.lithonite, undefined, GetCurrentPerson());
				CutScene_Play('TalkTo Villager_1');
				return;
			}else if (GetMapFlag('Kamajs_negociations')){
				nQ({ action: 'Talk',
					portrait: "portrait/kamajs_villager1.png",
					settings:{ portraitWindowAlignment : ALIGNMENT_TOPRIGHT },
					text: "Money!"
				});
				nQ(Game.lithonite.unfacePerson, Game.lithonite, undefined, GetCurrentPerson());
				CutScene_Play('TalkTo Villager_1');
				return;
			}
			QCutScene_Start();
			nQ({ action: 'Talk',
				portrait: "portrait/kamajs_villager1.png",
				settings:{ portraitWindowAlignment : ALIGNMENT_TOPRIGHT },
				text: "We are selling our products to this village. Negociations are still taking place."
				+" I hope we get good money for it!"
				,redraw:false // Dont redraw because the next talk action will need to copy the background.
			});
			nQ({ action: 'Talk',
				portrait: "portrait/daniel.png",
				caption: "Daniel",
				text: "So why is nobody else talking to me?"
				,redraw:false
			});
			nQ({ action: 'Talk',
				portrait: "portrait/kamajs_villager1.png",
				settings:{ portraitWindowAlignment : ALIGNMENT_TOPRIGHT },
				text: "It is custom to only let the negociating parties speak, the others keep quiet.\n"
				+"Oh! Here they come, the deal has been sealed. We now wil start delivering those orders.\n MONEY!"
			});
			nQ("Game.lithonite.unfacePerson('"+GetCurrentPerson()+"');");
			nQ({ action: 'Move',
				sprite: 'Villager_3',
				mstr: "NhWw2S",
				standstill: 'looksouth',
			});
			nQ({ action: 'CreatePerson',
				sprite: 'Villager_negociator',
				spriteset: 'male/00.body.rss',
				tx: 25, dx:8,
				ty: 12,
				direction: 'looksouth',
				frame: 0
			});
			nQ("Game.mixrss.SetSpritebase( GetPersonSpriteset('Villager_negociator'));");
			nQ("Game.mixrss.overMix('male/body/02.labcoat_white.rss');");
			nQ("Game.mixrss.overMix('male/legs/01.shoes_redsneakers.rss', ColorMatrix.Rotate_back);");
			nQ("SetPersonSpriteset('Villager_negociator', Game.mixrss.GetSpritebase());");

			nQ(PanCamToPerson, null, 'Villager_negociator', 4,4, true);
			nQ({ action: 'Move',
				sprite: 'Villager_negociator',
				mstr: "Ss4Ee4Ss5Ee5Nn"
			});
			nQ(PanCamToPerson, null, Game.lithonite.GIP, 16,16, true);
			nQ(DestroyPerson, null, 'Villager_negociator');
			nQ("SetMapFlag('Kamajs_negociations',1)");
			QCutScene_End();
			CutScene_Play('TalkTo Villager_1');
		}
	},

	Villager_3: {
		create: function(){
			SetPersonDirection(GetCurrentPerson(), "looksouth");

			Game.mixrss.SetSpritebase( GetPersonSpriteset(GetCurrentPerson()) );
			Game.mixrss.overMix("male/body/02.labcoat_white.rss");
			Game.mixrss.overMix("male/head/06.hair_pointy_red.rss", Game.ColorMatrix["Swap_red_and_blue"]);
			Game.mixrss.overMix("male/legs/01.shoes_redsneakers.rss", ColorMatrix["Swap_red_and_blue"]);
			SetPersonSpriteset(GetCurrentPerson(), Game.mixrss.GetSpritebase());
		},
		talk: function(){
			Game.lithonite.facePerson(undefined, GetCurrentPerson(), 'look', 'look', true);
			if(GetMapFlag('HasAccessOutsideOfKamajsReturn')){
				nQ({ action: 'Talk',
					caption: "Villager",
					settings:{ nameWindowAlignment : ALIGNMENT_TOPRIGHT },
					text: "I should never say this, but I've hidden a treasure inside the mine."
				});
			}else if (GetMapFlag('Kamajs_negociations')){
				if( 
					( Game.lithonite.GetPersonTX(Daniel) == Game.lithonite.GetPersonTX('Villager_3') )
					&&
					( Game.lithonite.GetPersonTY(Daniel) <= Game.lithonite.GetPersonTY('Villager_3') )
				){
					nQ({ action: 'Talk',
						caption: "Villager",
						settings:{ nameWindowAlignment : ALIGNMENT_TOPRIGHT },
						text: "Were you looking for the village elder? He went to the storageroom."
					});
					nQ({ action: 'Move',
						sprite: 'Villager_3',
						mstr: "Ww2S"
					});
				}else{
					nQ({ action: 'Talk',
						caption: "Villager",
						settings:{ nameWindowAlignment : ALIGNMENT_TOPRIGHT },
						text: "The prices have been set, now distribution has started. Say, you're not from around here."
						+" You should go talk to the village elder."
					});
				}
			}else{
				nQ({ action: 'Talk',
					caption: "Villager",
					settings:{ nameWindowAlignment : ALIGNMENT_TOPRIGHT },
					text: "..."
				});
			}
			nQ(Game.lithonite.unfacePerson, Game.lithonite, undefined, GetCurrentPerson());
			CutScene_Play('TalkTo Villager_3');
		}
	}	
})
